--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- This library provides generic functions for string manipulation, such as finding and extracting substrings, and pattern matching. When indexing a string in Lua, the first character is at position `1` (not at `0`, as in C). Indices are allowed to be negative and are interpreted as indexing backwards, from the end of the string. Thus, the last character is at position `-1`, and so on.
--- Several functions in this library (e.g., `find`, `gfind`, `gsub`), make use of [Lua patterns](https://www.lua.org/pil/20.2.html).
--- @class stringlib
string = {}

--- Returns `true` if a `string` ends with a given substring.
--- This function **does not** use pattern matching.
--- 
--- @param s string No description yet available.
--- @param pattern string No description yet available.
--- @return boolean result No description yet available.
function string.endswith(s, pattern) end

--- This function creates a string, given various values. The first parameter follows the [printf](http://www.cplusplus.com/reference/cstdio/printf) format, with the additional option of `%q` to automatically quote a string.
--- 
--- Specifier | Output												  | Example
--- --------- | ------------------------------------------------------- | -------------
--- `%d`	  | Signed decimal integer.								 | -392
--- `%i`	  | Same as `%d`.										   | -392
--- `%u`	  | Unsigned decimal integer.							   | 7235
--- `%o`	  | Unsigned octal.										 | 610
--- `%x`	  | Unsigned hexadecimal integer.						   | 7fa
--- `%X`	  | As `%x`, but uppercase.								 | 7FA
--- `%f`	  | Decimal floating point, lowercase.					  | 392.65
--- `%F`	  | Decimal floating point, uppercase.					  | 392.65
--- `%e`	  | Scientific notation (mantissa/exponent), lowercase.	 | 3.9265e+2
--- `%E`	  | Scientific notation (mantissa/exponent), uppercase.	 | 3.9265E+2
--- `%g`	  | Use the shortest representation: %e or %f.			  | 392.65
--- `%G`	  | Use the shortest representation: %E or %F.			  | 392.65
--- `%a`	  | Hexadecimal floating point, lowercase.				  | -0xc.90fep-2
--- `%A`	  | Hexadecimal floating point, uppercase.				  | -0XC.90FEP-2
--- `%c`	  | Character.											  | a
--- `%s`	  | String of characters.								   | sample
--- `%q`	  | Quoted string of characters.							| "sample"
--- `%p`	  | Pointer address.										| b8000000
--- `%%`	  | The literal `%` character.							  | %
--- @param format string The format string to use for the output.
--- @param ...? any *Optional*. Values to format into the specified `string`.
--- @return string result No description yet available.
function string.format(format, ...) end

--- Returns a string where one string has been inserted into another, after a specified position.
--- 		
--- For example, `string.insert("12345678", "abcdefgh", 5)` will return `"12345abcdefgh678"`.
--- @param s1 string The string to insert into.
--- @param s2 string The string to insert.
--- @param position integer An index of `s1`. The `s2` `string` will be inserted after this index.
--- @return string result A copy of `s1`, with `s2` inserted into it after the specified `position`.
function string.insert(s1, s2, position) end

--- Performs the logic of `string.find` on a `string` `s`, using a `table` of patterns.
--- 
--- If any of the `patterns` are found in `s`, then the matching `pattern` will be returned, followed by the normal results of `string.find`.
--- 	
--- The `patterns` are checked in the order they are passed. i.e., this function will first try to match `patterns[1]`, then `patterns[2]`, and so on.
--- @param s string The `string` to `find` `patterns` in.
--- @param patterns table An array-style `table` that contains the patterns to match.
--- @param index? integer *Default*: `1`. Start index of the `find`. (Same meaning as in `string.find`.)
--- @param plain? boolean *Default*: `false`. If `true`, then a normal search will be performed instead of a pattern search. (Same meaning as in `string.find`.)
--- @return string? pattern *Optional*. If a pattern was matched, then this will be the first pattern that was matched. If no patterns matched, this will be `nil`.
--- @return integer? startindex *Optional*. If a `pattern` was matched, this is the index of `s` where the matching `pattern` begins.
--- @return integer? endindex *Optional*. If a `pattern` was matched, this is the index of `s` where the matching `pattern` ends.
function string.multifind(s, patterns, index, plain) end

--- Returns an array-style table with a `string` split by a specified separator.
--- The seperator is not part of the results. 
--- By default the `sep == "%s"`, which will result in `str` getting split by whitespace characters (e.g. spaces and tabs).
--- 
--- !!! warning 
--- 	if `sep` is more than one character, then `str` will get split at each occurrence of any of the individual characters in `sep`.
--- 	For example, `string.split("1a2b3c4abc5", "abc")` will return `{"1", "2", "3", "4", "5"}` instead of `{"1a2b3c4", "5"}`.
--- 
--- @param str string The string to split.
--- @param sep? string *Default*: `"%s"`. The token to split the string by.
--- @return string[] split No description yet available.
function string.split(str, sep) end

--- Returns `true` if a `string` begins with a given substring.
--- This function **does not** use pattern matching.
--- @param s string No description yet available.
--- @param substring string No description yet available.
--- @return boolean result No description yet available.
function string.startswith(s, substring) end

--- Returns a copy of the string, with whitespace characters (e.g. spaces and tabs) removed from the start and end.
--- @param s string No description yet available.
--- @return string trimmed No description yet available.
function string.trim(s) end

